The `display` method in `Lib/AddressBookLib.php` has been updated to escape values by default.  This
also affects the `AddressBookHelper` as the display method in there just calls the other `display`
method.  The `display` method in the `AddressBookHelper` has been updated to accept a new `options`
parameter for optional params to be passed in.

## What Breaks & How to Fix

- There are some cases where the data you pass into either `display` is already escaped.  In these
situations you can pass in `[ 'escape' => false ]` as the third parameter to stop the `AddressBookLib`
from escaping it. Example:

```php
echo $this->AddressBook->display($address, '%s<br>', [ 'escape' => false ]);
```
